#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw
#define _max(a,b) (a)>(b)?(a):(b)
#define _min(a,b) (a)<(b)?(a):(b)

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE |CLK_ADDRESS_CLAMP_TO_EDGE  | CLK_FILTER_LINEAR;
vec4 INPUTSRC(image2d_t src_data,__global FilterParam* param, vec2 tc)
{
	tc = (vec2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);
	return read_imagef(src_data, sampler, tc);
}

vec4 INPUT(image2d_t src_data, vec2 tc)
{
	return read_imagef(src_data, sampler, tc);
}

__kernel void MAIN(
    __read_only image2d_t input1,
	__read_only image2d_t input2,
    __read_only image2d_t input3,        //Data in global memory
	__read_only image2d_t input4, 
	__read_only image2d_t input5, 
	__read_only image2d_t input6, 
	__write_only image2d_t dest_data, 
      __global FilterParam* param,
	  int strength) //range[0 - 100] //
{
	int W = get_global_size(0);
	int H = get_global_size(1);
	int textH = param->height[0];;
	float iGlobalTime = param->cur_time / param->total_time;
	
	int2 coordinate = (int2)(get_global_id(0), get_global_id(1));
	vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
	float2 iResolution = (float2)(W,H);
	vec2 tc = (fragCoord + (float2)(0.5f)) / (float2)(W,H);
	
	 vec4 orig = INPUTSRC(input1,  param, tc);
	vec3 texel = orig.xyz;
     vec3 edge = INPUT(input2, tc).xyz;
	texel = texel * edge;
	
	texel = (vec3)(
                 INPUT(input3, (vec2)(texel.z, .16666f)).z,
                 INPUT(input3, (vec2)(texel.y, .5f)).y,
                 INPUT(input3, (vec2)(texel.x, .83333f)).x);
	
	vec3 luma = (vec3)(.30f, .59f, .11f);
	vec3 gradSample = INPUT(input4, (vec2)(dot(luma, texel), .5f)).zyx;
	vec3 final = (vec3)(
                      INPUT(input5, (vec2)(gradSample.z, texel.z)).z,
                      INPUT(input5, (vec2)(gradSample.y, texel.y)).y,
                      INPUT(input5, (vec2)(gradSample.x, texel.x)).x
                      );
    
    vec3 metal = INPUT(input6, tc).xyz;
    vec3 metaled = (vec3)(
                        INPUT(input5, (vec2)(metal.z, texel.z)).z,
                        INPUT(input5, (vec2)(metal.y, texel.y)).y,
                        INPUT(input5, (vec2)(metal.x, texel.x)).x
                        );
	float4 outputCol = mix( (vec4)(metaled, 1.0f), orig, (vec4)( 1.0f - (float)strength/100.0f) ) ;
	write_imagef(dest_data, coordinate,  (vec4)(outputCol.xyz, orig.w));;
}